//*****************************************************************************
//*****************************************************************************
// Header file for class"DLA"
//*****************************************************************************
//*****************************************************************************
// Phillip Forkner
// Sep. 25, 2002
// 
//*****************************************************************************
#ifndef _DLA_
#define _DLA_

class DLA
{
public:
	DLA(int,int,int,
		double,int,double);	// Default Constructor (add default vals)
	virtual ~DLA();			// Destructor

	void simulate();		// Runs the simulation
	void potentialValsOut();// Writes the potential values to file (row by row)
	void gridOut();			// Write the grid points to file (x,y)

protected:
	void initGrid();		// Initializes the grid to 0's and sets the seed
	float getRandy(float n);// Get a random number in [0,n]
	bool getParticle();		// Introduces a particle on spawn circle
	bool moveCartesian();	// Moves in a random cardinal direction
	bool checkStick();		// Check if the particle sticks
	int findProba();		// Determine direction to move based on potentials
	void calcPot();			// Calculates the potential (four nearest neighbors)

private:
	int x,y;				// current position of the particle
	double r;				// max radius of the aggregate
	int dSpawn,dKill;		// r+dSpawn=Spawn radius; r+dKill=Kill radius
	int particles;			// number of particles in aggregate
	int iterations;			// number of particles introduced
	int n;					// To change grid size, change n in the constructor
	double grid[300][300];	// and the indices for grid.
	double potential;		// Value of the seed
	int modVal;				// used for printing progress
	float beta;				// probability factor
};

#endif